#include <string.h>
#include <itk/raster.h>
#include <itk/clone.h>

#ifndef DO_ITK_INLINE
#include <itk/clone.inl>
#endif


EMPTY_CONSTRUCTOR( Clone, Transformation)
EMPTY_DESTRUCTOR( Clone)


bool
Clone::do_clone( const Raster &src, Raster &dest)
{
  if (&src == &dest) {
    return true;
  }

  dest.redimension( src.width(), src.height(), src.depth(), src.interp());
  memcpy( dest.raster(), src.raster(), src.data_size());
  return true;
}
