#include <string.h>
#include <itk/raster.h>
#include <itk/invert.h>

#ifndef DO_ITK_INLINE
#include <itk/invert.inl>
#endif


EMPTY_CONSTRUCTOR( Invert, Transformation)
EMPTY_DESTRUCTOR( Invert)


bool
Invert::do_invert( const Raster &src, Raster &dest)
{
  try {
    if (&src != &dest) {
      dest.redimension( src.width(), src.height(), src.depth(), src.interp());
    }

    size_t        words = src.data_words();
    Raster_Word * s     = src.raster_word();
    Raster_Word * d     = src.raster_word();

    for (size_t i = 0; i < words; ++i) {
      d[ i] = ~s[ i];
    }
    return true;
  }
  catch (...) {
    return false;
  }
}
