#ifndef OCR_Dictionary_H
#define OCR_Dictionary_H

#include <map>
#include <vector>

#include <ocr/defines.h>


typedef unsigned Dict_Key;
typedef char     Dict_Token;

struct Dict_Key_Token {
  Dict_Key_Token();
  Dict_Key_Token( const Dict_Key &new_key, const Dict_Token &new_token);
  Dict_Key_Token( const Dict_Key_Token &rhs);
  Dict_Key_Token( Dict_Key_Token &rhs);

  Dict_Key    key;
  Dict_Token  token;
};

typedef std::map<Dict_Key,Dict_Token> Dict_Lookup;
typedef std::vector<Dict_Key_Token>   Dict_Search;

class Dictionary {
public:
  Dictionary();

  bool load( const char *filename);
  bool save( const char *filename) const;

  void add_key ( const Dict_Key &key, const Dict_Token &token);
  bool find_key( const Dict_Key &key,       Dict_Token &token);

  DECL_ACCESSOR_RO( Dictionary, unsigned, size)
private:
  Dict_Lookup    m_lookup;
  Dict_Search    m_search;
};


#ifdef DO_OCR_INLINE
#include <ocr/dictionary.inl>
#endif

#endif//OCR_Dictionary_H
