#ifndef OCR_Find_Chars_INL
#define OCR_Find_Chars_INL


ACCESSOR_RO( OCR_INLINE, Char_Def, unsigned, tl_x, m_tl_x)
ACCESSOR_RO( OCR_INLINE, Char_Def, unsigned, tl_y, m_tl_y)
ACCESSOR_RO( OCR_INLINE, Char_Def, unsigned, br_x, m_br_x)
ACCESSOR_RO( OCR_INLINE, Char_Def, unsigned, br_y, m_br_y)

OCR_INLINE void
Char_Def::set_pos( unsigned new_tl_x, unsigned new_tl_y
                 , unsigned new_br_x, unsigned new_br_y)
{
  m_tl_x = new_tl_x;
  m_tl_y = new_tl_y;
  m_br_x = new_br_x;
  m_br_y = new_br_y;
}


OCR_INLINE void
Char_Def::copy( const Char_Def &rhs)
{
  set_pos( rhs.tl_x(), rhs.tl_y(), rhs.br_x(), rhs.br_y());
}


ACCESSOR_RW( OCR_INLINE, Find_Chars, unsigned , min_line_size
           , m_min_line_size)
ACCESSOR_RW( OCR_INLINE, Find_Chars, unsigned , black_threshold
           , m_black_threshold)
ACCESSOR_RO( OCR_INLINE, Find_Chars, const Page &   , page           , m_page)


#endif//OCR_Find_Chars_INL
