#ifndef Common_Defines_H
#define Common_Defines_H

#define EMPTY_CONSTRUCTOR( object, base) \
object::object() \
: base() \
{}

#define SIMPLE_EMPTY_CONSTRUCTOR( object) \
object::object() \
{}

#define EMPTY_DESTRUCTOR( object) \
object::~object() \
{}

#define DENY_COPY( object) \
private: \
object( const object &); \
object( object &); \
const object & operator=( const object &); \
const object & operator=( object &);

#define DECL_ACCESSOR_RO( object, type, function) \
  type function() const;

#define DECL_ACCESSOR_WO( object, type, function) \
  object & function( type newval);

#define DECL_ACCESSOR_RW( object, type, function) \
  DECL_ACCESSOR_RO( object, type, function) \
  DECL_ACCESSOR_WO( object, type, function)

#define ACCESSOR_RO( INLINE, object, type, function, value) \
INLINE type object::function() const { return value; }

#define ACCESSOR_WO( INLINE, object, type, function, value) \
INLINE object & object::function( type newval) { value = newval; return *this;}

#define ACCESSOR_RW( INLINE, object, type, function, value) \
  ACCESSOR_RO( INLINE, object, type, function, value) \
  ACCESSOR_WO( INLINE, object, type, function, value)

#endif//Common_Defines_H
