#ifndef ITK_Transformation_H
#define ITK_Transformation_H

#include <itk/defines.h>

class Raster;

class Transformation {
/**
*** Purpose: Interface for all operations that change a <classname>Raster</a>
***          object.
*** Notes:   All transformations must be written in such a fashion that they
***          can safely have <varname>src</> and <varname>dest</a> be either
***          the same or different objects.
**/
public:
               Transformation();
  virtual      ~Transformation();

  virtual bool transform( const Raster &src, Raster &dest);
private:
  DENY_COPY( Transformation)
};


#ifdef DO_ITK_INLINE
#include <itk/transformation.inl>
#endif


#endif//ITK_Transformation_H
