#ifndef ITK_Writer_H
#define ITK_Writer_H

#include <itk/operation.h>


class Writer : public Operation {
public:
                 Writer();
                 Writer( const char *new_filename);
  virtual        ~Writer();

          bool   save( Raster &raster);
          bool   save( Raster &raster, const char *new_filename);

          bool   open_multipage();
          bool   open_multipage( const char *new_filename);
          bool   save_next( Raster &raster);
          bool   close_multipage();

  DECL_ACCESSOR_RO( Writer, bool        , is_open_multipage)
  DECL_ACCESSOR_RW( Writer, const char *, filename         )

protected:
  virtual bool   imp_open_multipage();
  virtual bool   imp_save_next( Raster &raster);
  virtual bool   imp_close_multipage();
private:
  DENY_COPY( Writer)

  DECL_ACCESSOR_WO( Writer, bool        , is_open_multipage)

  bool           m_is_open_multipage;
  char         * m_filename;
  size_t         m_max_filename_len;
};


#ifdef DO_ITK_INLINE
#include <itk/writer.inl>
#endif

#endif//ITK_Writer_H
