#ifndef OCR_Get_Skew_H
#define OCR_Get_Skew_H

#include <ocr/defines.h>


class Fixed;
class Raster;


class Get_Skew {
public:
  Get_Skew( unsigned new_max_angle   = 10, int new_sample_skip =  5);
  ~Get_Skew();

  DECL_ACCESSOR_RO( Get_Skew, const Raster &, raster     )
  DECL_ACCESSOR_RO( Get_Skew, double        , skew       )
  DECL_ACCESSOR_RW( Get_Skew, unsigned      , sample_skip)
  DECL_ACCESSOR_RW( Get_Skew, unsigned      , max_angle  )

  double          get_skew( const Raster &image);

private:
  DENY_COPY( Get_Skew)

  double          histogram( const Raster &raster, double angle);
  unsigned        cast_ray( const Raster &raster, int row
                          , const Fixed  &dx    , int dy);

  double          m_skew;
  int             m_sample_skip;
  unsigned        m_max_angle;
  unsigned        m_max_rows;
  unsigned      * m_rows;
};


#ifdef DO_OCR_INLINE
#include <ocr/get_skew.inl>
#endif


#endif//OCR_Get_Skew_H
