#ifndef OCR_Histogram_H
#define OCR_Histogram_H

#include <ocr/defines.h>

class Raster;

class Histogram {
public:
  Histogram();
  ~Histogram();

  DECL_ACCESSOR_RO( Histogram , double   , mean               )
  DECL_ACCESSOR_RO( Histogram , double   , standard_deviation )
  DECL_ACCESSOR_RO( Histogram , double   , variance           )

  double      construct( int skip, const Raster &raster);

private:
  double      m_mean;
  double      m_std_dev;
  double      m_variance;

  unsigned    m_row_count;
  unsigned    m_max_count;
  unsigned  * m_rows;
};

#ifdef DO_OCR_INLINE
#include <ocr/histogram.inl>
#endif

#endif//OCR_Histogram_H
