#include <string>
#include <stdio.h>
#include <iostream>
#include <tiffio.h>
#include <itk/itk.h>


using std::cout;

int
main( int argc, char **argv)
{
  TIFFSetWarningHandler( 0);
/*
  cout << "Raster             " << sizeof( Raster           ) << "\n"
       << "Assign             " << sizeof( Assign           ) << "\n"
       << "Clone              " << sizeof( Clone            ) << "\n"
       << "Invert             " << sizeof( Invert           ) << "\n"
       << "Operation          " << sizeof( Operation        ) << "\n"
       << "Reader             " << sizeof( Reader           ) << "\n"
       << "Rotate             " << sizeof( Rotate           ) << "\n"
       << "TIFF_Reader        " << sizeof( TIFF_Reader      ) << "\n"
       << "TIFF_Writer        " << sizeof( TIFF_Writer      ) << "\n"
       << "Transformation     " << sizeof( Transformation   ) << "\n"
       << "Writer             " << sizeof( Writer           ) << "\n";
*/

  if (argc < 2) {
    cout << "usage:\n  " << argv[ 0] << " in_tiff [out_tiff]\n\n";
    return 1;
  }

  Raster       src;
  Raster       dest;
  TIFF_Reader  reader;
  TIFF_Writer  writer;
  Rotate       rotate;
  char         bfs[ 128];

  if (!reader.open_multipage( argv[ 1])) {
    cout << "couldn't open " << argv[ 1] << "\n";
    return 1;
  }
  if (reader.load_next( src)) {
    src.is_black_low( false);
    for (double d = 0.0; d <= 20; d += 0.1) {
      rotate.angle( d);
      sprintf( bfs, "out_%06.3f.tif", d);
      rotate.transform( src, dest);
      writer.save( dest, bfs);
      rotate.angle( -d);
      sprintf( bfs, "out_-%06.3f.tif", d);
      rotate.transform( src, dest);
      writer.save( dest, bfs);
    }
  }
  reader.close_multipage();

  return 0;
}
