#ifndef ITK_TIFF_Writer_H
#define ITK_TIFF_Writer_H

#include <tiffio.h>
#include <itk/writer.h>


class TIFF_Writer : public Writer {
public:
                 TIFF_Writer();
                 TIFF_Writer( const char *new_filename);
                 ~TIFF_Writer();

  virtual bool   operate( Raster &raster);

protected:
  virtual bool   imp_open_multipage();
  virtual bool   imp_save_next( Raster &raster);
  virtual bool   imp_close_multipage();

private:
  DENY_COPY( TIFF_Writer)

  TIFF  * m_tiff;
};


#ifdef DO_ITK_INLINE
#include <itk/tiff_writer.inl>
#endif


#endif//ITK_TIFF_Writer_H
