#ifndef OCR_Find_Chars_H
#define OCR_Find_Chars_H

#include <vector>
#include <ocr/defines.h>


class Raster;


class Char_Def {
friend class Find_Chars;
public:
  Char_Def();
  Char_Def( unsigned x1, unsigned y1, unsigned x2, unsigned y2);
  Char_Def( Char_Def &rhs);
  Char_Def( const Char_Def &rhs);
  ~Char_Def();

  DECL_ACCESSOR_RO( Line_Def, unsigned, tl_x)
  DECL_ACCESSOR_RO( Line_Def, unsigned, tl_y)
  DECL_ACCESSOR_RO( Line_Def, unsigned, br_x)
  DECL_ACCESSOR_RO( Line_Def, unsigned, br_y)

  const Char_Def & operator=( Char_Def &rhs);
  const Char_Def & operator=( const Char_Def &rhs);
private:
  void set_pos( unsigned new_tl_x, unsigned new_tl_y
              , unsigned new_br_x, unsigned new_br_y);
  void copy( const Char_Def &rhs);

  unsigned   m_tl_x;
  unsigned   m_tl_y;
  unsigned   m_br_x;
  unsigned   m_br_y;
};

typedef std::vector<Char_Def>  Char_Defs;
typedef std::vector<Char_Defs> Page;


class Find_Chars {
public:
  Find_Chars( unsigned new_min_line_size, unsigned new_black_threshold = 1);
  ~Find_Chars();

  DECL_ACCESSOR_RW( Find_Chars, unsigned , min_line_size)
  DECL_ACCESSOR_RW( Find_Chars, unsigned , black_threshold)
  DECL_ACCESSOR_RO( Find_Chars, const Page &   , page)

  bool       find_chars( const Raster &raster);

private:
  bool       find_line( const Raster  & raster
                      ,       signed  & line_start
                      ,       signed  & line_end);
  bool       find_char( const Raster  & raster
                      ,       signed  & line_start
                      ,       signed  & line_end
                      ,       signed  & char_start
                      ,       signed  & char_end);

  Page       m_page;
  unsigned   m_min_line_size;
  unsigned   m_black_threshold;
};


#ifdef DO_OCR_INLINE
#include <ocr/find_chars.inl>
#endif

#endif//OCR_Find_Chars_H
