#include <itk/raster.h>
#include <itk/assign.h>

#ifndef DO_ITK_INLINE
#include <itk/assign.inl>
#endif


EMPTY_CONSTRUCTOR( Assign, Transformation)
EMPTY_DESTRUCTOR( Assign)


bool
Assign::do_assign( Raster &src, Raster &dest)
{
  if (&src == &dest) {
    return true;
  }

  dest.m_width       = src.m_width;
  dest.m_height      = src.m_height;
  dest.m_depth       = src.m_depth;
  dest.m_interp      = src.m_interp;
  dest.m_raster      = src.m_raster;
  dest.m_raster_size = src.m_raster_size;
  dest.m_row_size    = src.m_row_size;
  src.init();
  return true;
}
