#ifndef ITK_Operation_H
#define ITK_Operation_H

#include <itk/defines.h>

class Raster;

class Operation {
/**
*** Purpose: Interface for all operations that use, examine, or change
***          a <classname>Raster</> object
**/
public:
               Operation();
  virtual      ~Operation();

  virtual bool operate( Raster &raster);
  virtual bool operate( const Raster &raster);
private:
  DENY_COPY( Operation)
};


#ifdef DO_ITK_INLINE
#include <itk/operation.inl>
#endif


#endif//ITK_Operation_H
