#include <itk/raster.h>


#ifndef DO_ITK_INLINE
#include <itk/raster.inl>
#endif


Raster::Raster()
{
  init();
}
 

Raster::Raster(
  Dimension new_height
, Dimension new_width
, Colormetric new_depth
, ColorInterp new_interp
)
{
  init();
  redimension( new_height, new_width, new_depth, new_interp);
}


Raster::~Raster()
{
  flush();
}


void
Raster::init()
{
  m_width       = 0;
  m_height      = 0;
  m_depth       = colormetric_null;
  m_raster      = 0;
  m_raster_size = 0;
  m_row_size    = 0;
}


void
Raster::flush()
{
  delete []m_raster;
  init();
}


bool
Raster::redimension(
  Dimension   new_width
, Dimension   new_height
, Colormetric new_depth
, ColorInterp new_interp
)
{
  try {
    size_t new_sample   = (new_depth & 0x00ff);
    size_t word_size    = sizeof( unsigned);
    size_t word_bits    = (word_size >= 4) ? (word_size * 8) : 32;
    size_t data_bits    = (new_sample * new_width);
    size_t new_row      = ((data_bits + word_bits - 1) / word_bits) * word_size;
    size_t new_size     = (new_row * new_height);
    if (m_raster_size < new_size) {
      delete []m_raster;
      m_raster = 0;
      m_raster = new Raster_Cell[ new_size];
      m_raster_size = new_size;
    }
    m_width    = new_width;
    m_height   = new_height;
    m_depth    = new_depth;
    m_interp   = new_interp;
    m_row_size = new_row;
    return true;
  }
  catch (...) {
    throw;
  }
}
