#ifndef ITK_Raster_INL
#define ITK_Raster_INL


ACCESSOR_RO( ITK_INLINE, Raster, Dimension    , width       , m_width  )
ACCESSOR_RO( ITK_INLINE, Raster, Dimension    , height      , m_height )
ACCESSOR_RO( ITK_INLINE, Raster, Colormetric  , depth       , m_depth  )
ACCESSOR_RO( ITK_INLINE, Raster, ColorInterp  , interp      , m_interp )
ACCESSOR_RO( ITK_INLINE, Raster, size_t       , sample_size , m_depth  & 0xff)
ACCESSOR_RO( ITK_INLINE, Raster, bool         , is_paletted , m_interp & 0x02)
ACCESSOR_RO( ITK_INLINE, Raster, bool         , is_black_low, m_interp & 0x01)


ITK_INLINE Raster &
Raster::is_black_low( bool newval)
{
  m_interp = (newval ? colorinterp_low_is_black : colorinterp_low_is_white);
  return *this;
}


ACCESSOR_RO( ITK_INLINE, Raster, size_t       , row_size    , m_row_size)
ACCESSOR_RO( ITK_INLINE, Raster, size_t       , data_size   ,
    row_size() * height())
ACCESSOR_RO( ITK_INLINE, Raster, Raster_Data  , raster      , m_raster)
ACCESSOR_RO( ITK_INLINE, Raster, Raster_Word *, raster_word ,
    reinterpret_cast<Raster_Word *>( raster()))
ACCESSOR_RO( ITK_INLINE, Raster, size_t       , row_words   ,
    row_size() / sizeof( unsigned))
ACCESSOR_RO( ITK_INLINE, Raster, size_t       , data_words  ,
    row_words() * height())


ITK_INLINE Raster_Data
Raster::operator[]( size_t i) const
{
  return &m_raster[ i * row_size()];
}


#endif//ITK_Raster_INL
