#include <assert.h>
#include <string.h>
#include <itk/reader.h>

#ifndef DO_ITK_INLINE
#include <itk/reader.inl>
#endif


Reader::Reader()
: Operation()
, m_is_open_multipage( false)
, m_filename( 0)
, m_max_filename_len( 0)
{
}


Reader::Reader( const char *new_filename)
: Operation()
, m_is_open_multipage( false)
, m_filename( 0)
, m_max_filename_len( 0)
{
  filename( new_filename);
}


Reader::~Reader()
{
  if (is_open_multipage()) {
    close_multipage();
  }
  delete []m_filename;
}


Reader &
Reader::filename( const char *new_filename)
{
  size_t len = strlen( new_filename);
  if (len > m_max_filename_len) {
    delete []m_filename;
    m_filename = new char[ len+1];
    m_max_filename_len = len;
  }
  strcpy( m_filename, new_filename);
  return *this;
}


bool
Reader::imp_open_multipage()
{
  assert( !"Should not be in Reader::imp_open_multipage()");
  return false;
}


bool
Reader::imp_load_next( Raster &raster)
{
  assert( !"Should not be in Reader::imp_load_next()");
  return false;
}


bool
Reader::imp_close_multipage()
{
  assert( !"Should not be in Reader::imp_close_multipage()");
  return false;
}
