#ifndef ITK_Reader_H
#define ITK_Reader_H

#include <itk/operation.h>


class Reader : public Operation {
public:
                 Reader();
                 Reader( const char *new_filename);
  virtual        ~Reader();

          bool   load( Raster &raster);
          bool   load( Raster &raster, const char *new_filename);

          bool   open_multipage();
          bool   open_multipage( const char *new_filename);
          bool   load_next( Raster &raster);
          bool   close_multipage();

  DECL_ACCESSOR_RO( Reader, bool        , is_open_multipage)
  DECL_ACCESSOR_RW( Reader, const char *, filename         )

protected:
  virtual bool   imp_open_multipage();
  virtual bool   imp_load_next( Raster &raster);
  virtual bool   imp_close_multipage();
private:
  DENY_COPY( Reader)

  DECL_ACCESSOR_WO( Reader, bool        , is_open_multipage)

  bool           m_is_open_multipage;
  char         * m_filename;
  size_t         m_max_filename_len;
};


#ifdef DO_ITK_INLINE
#include <itk/reader.inl>
#endif

#endif//ITK_Reader_H
