#ifndef ITK_Rotate_H
#define ITK_Rotate_H

#include <itk/transformation.h>


class Rotate : public Transformation {
public:
                  Rotate();
                  Rotate( double new_angle);
  virtual         ~Rotate();

  virtual bool    transform( Raster &src, Raster &dest);
  virtual bool    transform( const Raster &src, Raster &dest);

          bool    rotate( const Raster &src, Raster &dest, double new_angle);

  DECL_ACCESSOR_RW( Rotate, double, angle)

private:
  DENY_COPY( Rotate)

          bool    do_rotate( const Raster &src, Raster &dest);

  double          m_angle;
};


#ifdef DO_ITK_INLINE
#include <itk/rotate.inl>
#endif

#endif//ITK_Rotate_H
