#ifndef ITK_TIFF_Reader_H
#define ITK_TIFF_Reader_H

#include <tiffio.h>
#include <itk/reader.h>


class TIFF_Reader : public Reader {
public:
                 TIFF_Reader();
                 TIFF_Reader( const char *new_filename);
                 ~TIFF_Reader();

  virtual bool   operate( Raster &raster);

protected:
  virtual bool   imp_open_multipage();
  virtual bool   imp_load_next( Raster &raster);
  virtual bool   imp_close_multipage();

private:
  DENY_COPY( TIFF_Reader)

  TIFF  * m_tiff;
  bool    m_more_pages;
};


#ifdef DO_ITK_INLINE
#include <itk/tiff_reader.inl>
#endif


#endif//ITK_TIFF_Reader_H
