#include <assert.h>
#include <string.h>
#include <itk/writer.h>

#ifndef DO_ITK_INLINE
#include <itk/writer.inl>
#endif


Writer::Writer()
: Operation()
, m_is_open_multipage( false)
, m_filename( 0)
, m_max_filename_len( 0)
{
}


Writer::Writer( const char *new_filename)
: Operation()
, m_is_open_multipage( false)
, m_filename( 0)
, m_max_filename_len( 0)
{
  filename( new_filename);
}


Writer::~Writer()
{
  if (is_open_multipage()) {
    close_multipage();
  }
  delete []m_filename;
}


Writer &
Writer::filename( const char *new_filename)
{
  size_t len = strlen( new_filename);
  if (len > m_max_filename_len) {
    delete []m_filename;
    m_filename = new char[ len+1];
    m_max_filename_len = len;
  }
  strcpy( m_filename, new_filename);
  return *this;
}


bool
Writer::imp_open_multipage()
{
  assert( !"Should not be in Writer::imp_open_multipage()");
  return false;
}


bool
Writer::imp_save_next( Raster &raster)
{
  assert( !"Should not be in Writer::imp_save_next()");
  return false;
}


bool
Writer::imp_close_multipage()
{
  assert( !"Should not be in Writer::imp_close_multipage()");
  return false;
}
