#ifndef OCR_Find_Lines_H
#define OCR_Find_Lines_H

#include <ocr/defines.h>


class Raster;


class Line_Def {
friend class Find_Lines;
public:
  Line_Def();
  Line_Def( unsigned m_start_line, unsigned m_end_line);

  DECL_ACCESSOR_RO( Line_Def, unsigned, start_line)
  DECL_ACCESSOR_RO( Line_Def, unsigned, end_line  )
private:
  void set_start_end( unsigned new_start_line, unsigned new_end_line);

  unsigned m_start_line;
  unsigned m_end_line;
};


class Find_Lines {
public:
  Find_Lines( unsigned m_min_line_size);
  ~Find_Lines();

  DECL_ACCESSOR_RW( Find_Lines, unsigned  , min_line_size)
  DECL_ACCESSOR_RW( Find_Lines, unsigned  , black_threshold)
  DECL_ACCESSOR_RO( Find_Lines, unsigned  , num_lines)
  DECL_ACCESSOR_RO( Find_Lines, Line_Def *, lines)

  bool       find_lines( const Raster &raster);

private:

  unsigned   m_num_lines;
  Line_Def * m_line_defs;
  unsigned   m_max_lines;
  unsigned   m_min_line_size;
  unsigned   m_black_threshold;
};


#ifdef DO_OCR_INLINE
#include <ocr/find_lines.inl>
#endif

#endif//OCR_Find_Lines_H
