#include <iostream>
#include <string>
#include <tiffio.h>
#include <itk/itk.h>
#include <ocr/get_skew.h>


int
main( int argc, char **argv)
{
  TIFFSetWarningHandler( 0);
  TIFFSetErrorHandler( 0);
  char * image = argv[ 1];
  Raster orig_raster;
  Raster ocr_raster;
  Get_Skew get_skew( 10, 0.1, 2);

  if (!TIFF_Reader( image).load( orig_raster)) {
    cerr << "couldn't load '" << image << "'" << endl;
    return 1;
  }

  if (orig_raster.is_paletted()) {
    cerr << "can't use paletted images" << endl;
    return 2;
  }
  if (orig_raster.is_black_low()) {
    orig_raster.is_black_low( false);
    Invert().transform( orig_raster, orig_raster);
  }

//  cout << image << endl;
  get_skew.get_skew( orig_raster);
  cout << image << "   " << "Skew == " << get_skew.skew() << endl;
  
  return 0;
}
